/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.AdvancedWizardPage;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingEventOptionsWizardPage;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import org.openjdk.jmc.flightrecorder.controlpanel.ui.wizards.RecordingWizardPage;
import org.openjdk.jmc.ui.wizards.IPerformFinishable;

public abstract class RecordingWizard
extends Wizard {
    private final RecordingWizardModel m_model;

    public RecordingWizard(RecordingWizardModel model) {
        this.m_model = model;
        this.setWindowTitle(model.isEditing() ? Messages.EDIT_RECORDING_WIZARD_PAGE_TITLE : Messages.START_RECORDING_WIZARD_PAGE_TITLE);
    }

    public boolean performFinish() {
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean subFinish;
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof IPerformFinishable && !(subFinish = ((IPerformFinishable)page).performFinish())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)new RecordingWizardPage(this.m_model));
        this.addPage((IWizardPage)new RecordingEventOptionsWizardPage(this.m_model));
        this.addPage((IWizardPage)new AdvancedWizardPage(this.m_model));
    }

    protected RecordingWizardModel getModel() {
        return this.m_model;
    }
}

