/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.combine;

import org.openjdk.jmc.flightrecorder.rules.jdk.combine.Combinable;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.Combiner;

public class SpanSquare
implements Combinable<SpanSquare> {
    public final long start;
    public final long end;
    public final long mass;
    public final double density;

    public SpanSquare(long start, long end) {
        this(start, end, end - start);
    }

    public SpanSquare(long start, long end, long mass) {
        this(start, end, mass, SpanSquare.calculateDensity(start, end, mass));
    }

    private SpanSquare(long start, long end, long mass, double density) {
        this.start = start;
        this.end = end;
        this.mass = mass;
        this.density = density;
    }

    @Override
    public SpanSquare combineWith(SpanSquare other) {
        long combinedMass = this.mass + other.mass;
        double combinedDensity = SpanSquare.calculateDensity(this.start, other.end, combinedMass);
        return combinedDensity > this.density && combinedDensity > other.density ? new SpanSquare(this.start, other.end, combinedMass, combinedDensity) : null;
    }

    private static double calculateDensity(long start, long end, long mass) {
        return (double)mass * ((double)mass / (double)(end - start));
    }

    public static SpanSquare getMax(SpanSquare[] clusters) {
        if (clusters.length == 1) {
            return clusters[0];
        }
        SpanSquare max = null;
        int clusterCount = Combiner.combine((Combinable[])clusters);
        for (int j = 0; j < clusterCount; ++j) {
            if (max != null && !(max.density < clusters[j].density)) continue;
            max = clusters[j];
        }
        return max;
    }

    public String toString() {
        return "SpanSquare:  value: " + this.mass + " start, " + this.start + ", end " + this.end;
    }
}

