/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.compilation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.common.version.JavaVMVersionToolkit;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class CodeCacheRule
implements IRule {
    public static final String CODE_CACHE_RESULT_ID = "CodeCache";
    private static final String NON_PROFILED_NAME = "CodeHeap 'non-profiled nmethods'";
    private static final String PROFILED_NAME = "CodeHeap 'profiled nmethods'";
    private static final String NON_NMETHODS_NAME = "CodeHeap 'non-nmethods'";
    public static final TypedPreference<IQuantity> CODE_CACHE_SIZE_INFO_PERCENT = new TypedPreference("codeCache.size.info.limit", Messages.getString("CodeCacheRuleFactory_SIZE_INFO_LIMIT"), Messages.getString("CodeCacheRuleFactory_SIZE_INFO_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(50L));
    public static final TypedPreference<IQuantity> CODE_CACHE_SIZE_WARN_PERCENT = new TypedPreference("codeCache.size.warn.limit", Messages.getString("CodeCacheRuleFactory_SIZE_WARN_LIMIT"), Messages.getString("CodeCacheRuleFactory_SIZE_WARN_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(80L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(CODE_CACHE_SIZE_INFO_PERCENT, CODE_CACHE_SIZE_WARN_PERCENT);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.JVMInformation", RulesToolkit.EventAvailability.AVAILABLE).addEventType("jdk.CodeCacheConfiguration", RulesToolkit.EventAvailability.AVAILABLE).addEventType("jdk.CodeCacheStatistics", RulesToolkit.EventAvailability.AVAILABLE).addEventType("jdk.CodeCacheFull", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final ContentType<CodeHeapData> CODE_HEAP = UnitLookup.createSyntheticContentType((String)"codeHeapData");
    public static final TypedResult<IQuantity> CODE_CACHE_FREE_RATIO = new TypedResult("codeCacheFreeRatio", "Code Cache Free Ratio", "The percentage of the code cache that was free.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedCollectionResult<CodeHeapData> CODE_HEAPS = new TypedCollectionResult("codeHeaps", "Code Heaps", "The code heaps in the JVM.", CODE_HEAP, CodeHeapData.class);
    public static final TypedResult<IQuantity> CODE_CACHE_RESERVED_SIZE = new TypedResult("reservedSize", "Code Cache Reserved Size", "The reserved size for the code cache.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IQuantity> CODE_CACHE_FULL_COUNT = new TypedResult("codeCacheFullCount", "Code Cache Full Count", "The number of times the code cache was full.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, CODE_CACHE_FREE_RATIO, CODE_CACHE_RESERVED_SIZE, CODE_CACHE_FULL_COUNT);

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return CodeCacheRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IItemCollection ccItems = items.apply(JdkFilters.CODE_CACHE_CONFIGURATION);
        IType ccType = RulesToolkit.getType((IItemCollection)ccItems, (String)"jdk.CodeCacheConfiguration");
        IQuantity ccReserved = (IQuantity)ccItems.getAggregate(Aggregators.min((String)"jdk.CodeCacheConfiguration", (IAttribute)JdkAttributes.RESERVED_SIZE));
        IQuantity ccFullCount = (IQuantity)items.getAggregate(JdkAggregators.CODE_CACHE_FULL_COUNT);
        if (ccFullCount != null && ccFullCount.doubleValue() > 0.0) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("CodeCacheRuleFactory_TEXT_WARN")).addResult(CODE_CACHE_RESERVED_SIZE, (Object)ccReserved).addResult(CODE_CACHE_FULL_COUNT, (Object)ccFullCount).setExplanation(Messages.getString("CodeCacheRuleFactory_TEXT_WARN_LONG")).setSolution(Messages.getString("CodeCacheRuleFactory_BLOG_REFERENCE")).build();
        }
        IQuantity infoPreferenceValue = (IQuantity)valueProvider.getPreferenceValue(CODE_CACHE_SIZE_INFO_PERCENT);
        IQuantity warningPreferenceValue = (IQuantity)valueProvider.getPreferenceValue(CODE_CACHE_SIZE_WARN_PERCENT);
        double allocationRatioScore = 0.0;
        String longDescription = null;
        ResultBuilder builder = ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider);
        if (this.hasSegmentedCodeCache(items)) {
            IQuantity worstRatio;
            if (!ccType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.PROFILED_SIZE)) {
                return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)ccType, (IAttribute)JdkAttributes.PROFILED_SIZE, (IPreferenceValueProvider)valueProvider);
            }
            IQuantity profiledAggregate = (IQuantity)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.min((IAttribute)JdkAttributes.UNALLOCATED), (IItemFilter)ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.CODE_HEAP, (String)PROFILED_NAME)));
            ITypedQuantity profiledRatio = null;
            profiledRatio = profiledAggregate != null ? UnitLookup.PERCENT_UNITY.quantity(profiledAggregate.ratioTo((IQuantity)items.getAggregate(Aggregators.min((IAttribute)JdkAttributes.PROFILED_SIZE)))) : UnitLookup.PERCENT_UNITY.quantity(1.0);
            IQuantity nonProfiledAggregate = (IQuantity)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.min((IAttribute)JdkAttributes.UNALLOCATED), (IItemFilter)ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.CODE_HEAP, (String)NON_PROFILED_NAME)));
            ITypedQuantity nonProfiledRatio = null;
            nonProfiledRatio = nonProfiledAggregate != null ? UnitLookup.PERCENT_UNITY.quantity(nonProfiledAggregate.ratioTo((IQuantity)items.getAggregate(Aggregators.min((IAttribute)JdkAttributes.NON_PROFILED_SIZE)))) : UnitLookup.PERCENT_UNITY.quantity(1.0);
            ITypedQuantity nonNMethodsRatio = UnitLookup.PERCENT_UNITY.quantity(((IQuantity)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.min((IAttribute)JdkAttributes.UNALLOCATED), (IItemFilter)ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.CODE_HEAP, (String)NON_NMETHODS_NAME)))).ratioTo((IQuantity)items.getAggregate(Aggregators.min((IAttribute)JdkAttributes.NON_NMETHOD_SIZE))));
            ArrayList<CodeHeapData> heaps = new ArrayList<CodeHeapData>();
            this.addIfHalfFull((IQuantity)profiledRatio, heaps, PROFILED_NAME);
            this.addIfHalfFull((IQuantity)nonProfiledRatio, heaps, NON_PROFILED_NAME);
            this.addIfHalfFull((IQuantity)nonNMethodsRatio, heaps, NON_NMETHODS_NAME);
            heaps.sort(null);
            builder.addResult(CODE_HEAPS, heaps);
            if (heaps.size() > 0) {
                if (heaps.size() > 1) {
                    builder.setSummary(Messages.getString("CodeCacheRuleFactory_WARN_SEGMENTED_HEAPS_SHORT_DESCRIPTION"));
                } else {
                    builder.setSummary(Messages.getString("CodeCacheRuleFactory_WARN_SEGMENTED_HEAP_SHORT_DESCRIPTION"));
                }
                longDescription = Messages.getString("CodeCacheRuleFactory_WARN_LONG_DESCRIPTION") + "\n" + Messages.getString("CodeCacheRuleFactory_DEFAULT_LONG_DESCRIPTION") + "\n" + Messages.getString("CodeCacheRuleFactory_BLOG_REFERENCE");
                builder.setExplanation(longDescription);
                worstRatio = ((CodeHeapData)heaps.get(0)).getRatio();
            } else {
                List<IQuantity> ratios = Arrays.asList(profiledRatio, nonProfiledRatio, nonNMethodsRatio);
                ratios.sort(null);
                worstRatio = ratios.get(0);
            }
            allocationRatioScore = RulesToolkit.mapExp100((double)(100.0 - worstRatio.doubleValueIn((IUnit)UnitLookup.PERCENT)), (double)infoPreferenceValue.doubleValueIn((IUnit)UnitLookup.PERCENT), (double)warningPreferenceValue.doubleValueIn((IUnit)UnitLookup.PERCENT));
        } else {
            if (!ccType.hasAttribute((ICanonicalAccessorFactory)JdkAttributes.RESERVED_SIZE)) {
                return RulesToolkit.getMissingAttributeResult((IRule)this, (IType)ccType, (IAttribute)JdkAttributes.RESERVED_SIZE, (IPreferenceValueProvider)valueProvider);
            }
            IQuantity codeCacheReserved = (IQuantity)items.getAggregate(Aggregators.min((String)"jdk.CodeCacheConfiguration", (IAttribute)JdkAttributes.RESERVED_SIZE));
            IQuantity unallocated = (IQuantity)items.getAggregate(Aggregators.min((String)"jdk.CodeCacheStatistics", (IAttribute)JdkAttributes.UNALLOCATED));
            ITypedQuantity unallocatedCodeCachePercent = UnitLookup.PERCENT_UNITY.quantity(unallocated.ratioTo(codeCacheReserved));
            allocationRatioScore = RulesToolkit.mapExp100((double)(100.0 - unallocatedCodeCachePercent.doubleValueIn((IUnit)UnitLookup.PERCENT)), (double)infoPreferenceValue.doubleValueIn((IUnit)UnitLookup.PERCENT), (double)warningPreferenceValue.doubleValueIn((IUnit)UnitLookup.PERCENT));
            builder.setSummary(Messages.getString("CodeCacheRuleFactory_JDK8_TEXT_WARN")).addResult(CODE_CACHE_FREE_RATIO, (Object)unallocatedCodeCachePercent);
            longDescription = Messages.getString("CodeCacheRuleFactory_DEFAULT_LONG_DESCRIPTION") + "\n" + Messages.getString("CodeCacheRuleFactory_BLOG_REFERENCE");
            builder.setExplanation(longDescription);
        }
        if (allocationRatioScore >= 25.0) {
            return builder.setSeverity(Severity.get((double)allocationRatioScore)).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(allocationRatioScore)).build();
        }
        return builder.setSeverity(Severity.OK).setSummary(Messages.getString("CodeCacheRuleFactory_TEXT_OK")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(allocationRatioScore)).build();
    }

    private boolean hasSegmentedCodeCache(IItemCollection items) {
        JavaVersion version = RulesToolkit.getJavaVersion((IItemCollection)items);
        String jvmName = (String)items.getAggregate(JdkAggregators.JVM_NAME);
        boolean isZing = JavaVMVersionToolkit.isZingJVMName((String)jvmName);
        if (version != null && version.getMajorVersion() >= 9 && !isZing) {
            return (Boolean)items.apply(ItemFilters.matches((ICanonicalAccessorFactory)JdkAttributes.FLAG_NAME, (String)"SegmentedCodeCache")).getAggregate(Aggregators.and((String)"jdk.BooleanFlag", (IAttribute)JdkAttributes.FLAG_VALUE_BOOLEAN));
        }
        return false;
    }

    private void addIfHalfFull(IQuantity ratioUnallocated, List<CodeHeapData> heaps, String name) {
        if (ratioUnallocated.compareTo((Object)UnitLookup.PERCENT_UNITY.quantity(0.5)) < 0) {
            heaps.add(new CodeHeapData(name, ratioUnallocated));
        }
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return CODE_CACHE_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("CodeCacheRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "code_cache";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }

    private static class CodeHeapData
    implements Comparable<CodeHeapData>,
    IDisplayable {
        private String name;
        private IQuantity ratio;

        CodeHeapData(String name, IQuantity ratio) {
            this.name = name;
            this.ratio = ratio;
        }

        public IQuantity getRatio() {
            return this.ratio;
        }

        public String toString() {
            return this.name + "(" + this.ratio.displayUsing("auto") + ")";
        }

        @Override
        public int compareTo(CodeHeapData o) {
            return this.ratio.compareTo((Object)o.getRatio());
        }

        public int hashCode() {
            return this.name.hashCode() << this.ratio.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof CodeHeapData) {
                CodeHeapData other = (CodeHeapData)o;
                return this.ratio.compareTo((Object)other.ratio) == 0 && this.name.equals(other.name);
            }
            return false;
        }

        public String displayUsing(String formatHint) {
            return this.name + "(" + this.ratio.displayUsing(formatHint) + ")";
        }
    }
}

