/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.common.version.JavaVersion;
import org.openjdk.jmc.common.version.JavaVersionSupport;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class DebugNonSafepointsRule
implements IRule {
    private static final String DEBUG_NON_SAFEPOINTS_RESULT_ID = "DebugNonSafepoints";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = new HashMap<String, RulesToolkit.EventAvailability>();

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        boolean dnsEnabled = null != RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JVM_ARGUMENTS, (String)"\\-XX\\:\\+DebugNonSafepoints", (boolean)false);
        boolean dnsDisabled = null != RulesToolkit.findMatches((String)"jdk.JVMInformation", (IItemCollection)items, (IAttribute)JdkAttributes.JVM_ARGUMENTS, (String)"\\-XX\\:\\-DebugNonSafepoints", (boolean)false);
        JavaVersion javaVersion = RulesToolkit.getJavaSpecVersion((IItemCollection)items);
        if (javaVersion == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSummary(Messages.getString("General_TEXT_COULD_NOT_DETERMINE_JAVA_VERSION")).setSeverity(Severity.NA).build();
        }
        boolean implicitlyEnabled = javaVersion.isGreaterOrEqualThan(JavaVersionSupport.DEBUG_NON_SAFEPOINTS_IMPLICITLY_ENABLED);
        if (!implicitlyEnabled) {
            if (dnsDisabled) {
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("DebugNonSafepointsRule_DISABLED_RESULT_SUMMARY")).setExplanation(Messages.getString("DebugNonSafepointsRule_NOT_ENABLED_RESULT_EXPLANATION")).setExplanation(Messages.getString("DebugNonSafepointsRule_NOT_ENABLED_RESULT_SOLUTION")).build();
            }
            if (!dnsEnabled) {
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("DebugNonSafepointsRule_NOT_ENABLED_RESULT_SUMMARY")).setExplanation(Messages.getString("DebugNonSafepointsRule_NOT_ENABLED_RESULT_EXPLANATION")).setSolution(Messages.getString("DebugNonSafepointsRule_NOT_ENABLED_RESULT_SOLUTION")).build();
            }
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("DebugNonSafepointsRule_TEXT_OK")).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("DebugNonSafepointsRule_IMPLICIT_TEXT_OK")).build();
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return DEBUG_NON_SAFEPOINTS_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("DebugNonSafepointsRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider preferenceValueProvider, final IResultValueProvider dependencyResults) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return DebugNonSafepointsRule.this.getResult(items, preferenceValueProvider, dependencyResults);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedResult<?>> getResults() {
        return Collections.emptyList();
    }

    static {
        REQUIRED_EVENTS.put("jdk.InitialSystemProperty", RulesToolkit.EventAvailability.AVAILABLE);
    }
}

