/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.io;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.owasp.encoder.Encode;

public class FileForceRule
implements IRule {
    public static final TypedPreference<IQuantity> FORCE_INFO_LIMIT = new TypedPreference("io.file.force.info.limit", Messages.getString("FileForceRule_CONFIG_INFO_LIMIT"), Messages.getString("FileForceRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(50L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(FORCE_INFO_LIMIT);
    private static final String RESULT_ID = "FileForce";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.FileForce", RulesToolkit.EventAvailability.AVAILABLE).build();
    public static final TypedResult<IQuantity> LONGEST_FORCE_TIME = new TypedResult("longestForceTime", "Longest Force (Time)", "The longest time it took to perform a file force.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<String> LONGEST_FORCE_PATH = new TypedResult("longestForcePath", "Longest Force (Path)", "The path of the file force that took the longest time.", UnitLookup.PLAIN_TEXT, String.class);
    public static final TypedResult<IQuantity> LONGEST_TOTAL_FORCE = new TypedResult("totalForceForLongest", "Total Force (Top File)", "The total duration of all file forced for the file with the longest force.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> AVERAGE_FILE_FORCE = new TypedResult("averageFileForce", "Average File Force", "The average duration of all file force.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_FILE_FORCE = new TypedResult("totalFileForce", "Total File Force", "The total duration of all file forced.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, LONGEST_FORCE_PATH, LONGEST_FORCE_TIME, LONGEST_TOTAL_FORCE, AVERAGE_FILE_FORCE, TOTAL_FILE_FORCE);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider resultProvider) {
        long infoLimit = ((IQuantity)vp.getPreferenceValue(FORCE_INFO_LIMIT)).longValue();
        IItemCollection fileForceEvents = items.apply(JdkFilters.FILE_FORCE);
        IItem longestEvent = (IItem)fileForceEvents.getAggregate(Aggregators.itemWithMax((IAttribute)JfrAttributes.DURATION));
        IQuantity longestDuration = (IQuantity)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JfrAttributes.DURATION);
        double score = RulesToolkit.mapExp74((double)longestDuration.doubleValueIn((IUnit)UnitLookup.MILLISECOND), (double)infoLimit);
        Severity severity = Severity.get((double)score);
        if (score >= (double)infoLimit) {
            String longestIOPath = (String)RulesToolkit.getValue((IItem)longestEvent, (IAccessorFactory)JdkAttributes.IO_PATH);
            String fileName = FileForceRule.sanitizeFileName(longestIOPath);
            IQuantity avgDuration = (IQuantity)fileForceEvents.getAggregate(Aggregators.avg((String)"jdk.FileForce", (IAttribute)JfrAttributes.DURATION));
            IQuantity totalDuration = (IQuantity)fileForceEvents.getAggregate(Aggregators.sum((String)"jdk.FileForce", (IAttribute)JfrAttributes.DURATION));
            IItemCollection eventsFromLongestIOPath = fileForceEvents.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.IO_PATH, (Object)longestIOPath));
            IQuantity totalLongestIOPath = (IQuantity)eventsFromLongestIOPath.getAggregate(Aggregators.sum((String)"jdk.FileForce", (IAttribute)JfrAttributes.DURATION));
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(severity).setSummary(Messages.getString("FileForceRuleFactory_TEXT_WARN")).setExplanation(Messages.getString("FileForceRuleFactory_TEXT_WARN_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LONGEST_FORCE_TIME, (Object)longestDuration).addResult(AVERAGE_FILE_FORCE, (Object)avgDuration).addResult(TOTAL_FILE_FORCE, (Object)totalDuration).addResult(LONGEST_TOTAL_FORCE, (Object)totalLongestIOPath).addResult(LONGEST_FORCE_PATH, (Object)fileName).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(severity).setSummary(Messages.getString("FileForceRuleFactory_TEXT_OK")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(LONGEST_FORCE_TIME, (Object)longestDuration).build();
    }

    static String sanitizeFileName(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return Encode.forHtml((String)Messages.getString("General_UNKNOWN_FILE_NAME"));
        }
        return Encode.forHtml((String)fileName);
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return FileForceRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("FileForceRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "file_io";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

