/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.latency;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.GroupingAggregator;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class ContextSwitchRule
implements IRule {
    public static final TypedPreference<IQuantity> CONTEXT_SWITCH_WARNING_LIMIT = new TypedPreference("contextswitch.warning.limit", Messages.getString("ContextSwitchRule_CONFIG_WARNING_LIMIT"), Messages.getString("ContextSwitchRule_CONFIG_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(10000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(CONTEXT_SWITCH_WARNING_LIMIT);
    private static final String RESULT_ID = "ContextSwitch";
    private static final IAggregator<IQuantity, ?> MAX_BLOCKS = GroupingAggregator.buildMax((String)Messages.getString("ContextSwitchRule_AGGR_MAX_BLOCKS"), null, (IAccessorFactory)JdkAttributes.MONITOR_ADDRESS, (IAggregator)JdkAggregators.TOTAL_BLOCKED_COUNT);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ThreadContextSwitchRate", RulesToolkit.EventAvailability.AVAILABLE).build();
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE);

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider vp, IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return ContextSwitchRule.this.evaluate(items, vp);
            }
        });
        return evaluationTask;
    }

    private IResult evaluate(IItemCollection items, IPreferenceValueProvider vp) {
        String longText;
        String text;
        int warningLimit;
        int infoLimit;
        long switchRateLimit = ((IQuantity)vp.getPreferenceValue(CONTEXT_SWITCH_WARNING_LIMIT)).clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        long switchRate = ContextSwitchRule.calculateSwitchRate(items);
        if (switchRate == -1L) {
            return RulesToolkit.getTooFewEventsResult((IRule)this, (IPreferenceValueProvider)vp);
        }
        long mostBlocks = switchRate > switchRateLimit ? ContextSwitchRule.getMostBlocks(items) : 0L;
        double score = RulesToolkit.mapExp100((double)mostBlocks, (double)(infoLimit = (warningLimit = 100) / 2), (double)warningLimit);
        if (score < 25.0) {
            text = Messages.getString("ContextSwitchRuleFactory_TEXT_OK");
            longText = null;
        } else {
            text = Messages.getString("ContextSwitchRuleFactory_TEXT_INFO");
            longText = Messages.getString("ContextSwitchRuleFactory_TEXT_INFO_LONG");
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(text).setExplanation(longText).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).build();
    }

    private static long calculateSwitchRate(IItemCollection switchItems) {
        IQuantity aggregate = (IQuantity)switchItems.getAggregate(Aggregators.avg((String)"jdk.ThreadContextSwitchRate", (IAttribute)JdkAttributes.OS_SWITCH_RATE));
        return aggregate == null ? -1L : aggregate.longValue();
    }

    private static long getMostBlocks(IItemCollection items) {
        IQuantity aggregate = (IQuantity)items.getAggregate(MAX_BLOCKS);
        return aggregate == null ? 0L : aggregate.longValue();
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ContextSwitchRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "lock_instances";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

