/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.DependsOn;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.CollectorType;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionInfoRule;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.GarbageCollectionsInfo;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

@DependsOn(value=GarbageCollectionInfoRule.class)
public class GcStallRule
implements IRule {
    private static final String GC_STALL_RESULT_ID = "GcStall";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.GarbageCollection", RulesToolkit.EventAvailability.AVAILABLE).addEventType("jdk.GCConfiguration", RulesToolkit.EventAvailability.ENABLED).build();

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                IQuantity c;
                GarbageCollectionsInfo aggregate = (GarbageCollectionsInfo)resultProvider.getResultValue(GarbageCollectionInfoRule.GC_INFO);
                if (aggregate.foundNonRequestedSerialOldGc()) {
                    CollectorType oldCollectorType = CollectorType.getOldCollectorType(items);
                    if (oldCollectorType == CollectorType.CMS) {
                        return ResultBuilder.createFor((IRule)GcStallRule.this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("SerialOldRuleFactory_TEXT_WARN_CMS")).setExplanation(Messages.getString("SerialOldRuleFactory_TEXT_WARN_CMS_LONG")).build();
                    }
                    if (oldCollectorType == CollectorType.G1_OLD) {
                        return ResultBuilder.createFor((IRule)GcStallRule.this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("SerialOldRuleFactory_TEXT_WARN_G1")).setExplanation(Messages.getString("SerialOldRuleFactory_TEXT_WARN_G1_LONG")).build();
                    }
                }
                if ((c = (IQuantity)items.getAggregate(Aggregators.count(null, null, (IItemFilter)JdkFilters.CONCURRENT_MODE_FAILURE))) != null && c.clampedLongValueIn((IUnit)UnitLookup.NUMBER_UNITY) > 0L) {
                    return ResultBuilder.createFor((IRule)GcStallRule.this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.WARNING).setSummary(Messages.getString("ConcurrentFailedRuleFactory_TEXT_WARN")).setExplanation(Messages.getString("ConcurrentFailedRuleFactory_TEXT_WARN_LONG")).build();
                }
                return ResultBuilder.createFor((IRule)GcStallRule.this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("GcStallRule_TEXT_OK")).build();
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return GC_STALL_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("GcStallRule_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return Collections.emptyList();
    }
}

