/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.openjdk.jmc.common.io.ValidatingObjectInputStream;

class DecryptedStorage {
    private static final String HMAC_ALGORITHM = "HmacSHA1";
    private static final String RANDOM_GEN_ALGORITHM = "SHA1PRNG";
    static final int SALT_LEN = 8;
    private static final int ITERATION_COUNT_MIN = 100000;
    private static final int ITERATION_COUNT_RANGE = 10000;
    private static final String SEP = "_";
    UUID storeId;
    long nextId;
    Map<String, Object> objects;

    DecryptedStorage() {
        this.objects = new HashMap<String, Object>();
        this.storeId = UUID.randomUUID();
    }

    DecryptedStorage(String encryptedStore, String cipher, String pwd) throws Exception {
        String[] parts = encryptedStore.split(SEP, 4);
        byte[] encodedData = DecryptedStorage.fromBase64(parts[0]);
        String encryptedStoreSign = parts[1];
        byte[] encodedParameter = DecryptedStorage.fromBase64(parts[2]);
        String parameterAlgorithm = parts[3];
        Cipher pbeCipher = Cipher.getInstance(cipher);
        AlgorithmParameters parameters = AlgorithmParameters.getInstance(parameterAlgorithm);
        parameters.init(encodedParameter);
        PBEParameterSpec pbeParamSpec = parameters.getParameterSpec(PBEParameterSpec.class);
        byte[] salt = pbeParamSpec.getSalt();
        int iterationCount = pbeParamSpec.getIterationCount();
        pbeCipher.init(2, DecryptedStorage.getKey(cipher, pwd, salt, iterationCount), parameters);
        byte[] decrypted = pbeCipher.doFinal(encodedData);
        if (!DecryptedStorage.calculateSignature(decrypted, pwd).equals(encryptedStoreSign)) {
            throw new SecurityException("Incorrect signature");
        }
        Throwable throwable = null;
        Object var16_17 = null;
        try (ValidatingObjectInputStream ois = ValidatingObjectInputStream.build((InputStream)new ByteArrayInputStream(decrypted));){
            Map objs;
            this.nextId = ois.safeReadLong();
            this.storeId = (UUID)ois.safeReadObject(UUID.class, null, 1, 100L);
            this.objects = objs = (Map)ois.safeReadObject(HashMap.class, Arrays.asList(String.class), 100000, 1000000L);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    String getEncrypted(String cipher, String pwd) throws Exception {
        SecureRandom random = SecureRandom.getInstance(RANDOM_GEN_ALGORITHM, "SUN");
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        int iterationCount = 100000 + random.nextInt(10000);
        return this.getEncrypted(cipher, pwd, salt, iterationCount);
    }

    String getEncrypted(String cipher, String pwd, byte[] salt, int iterationCount) throws Exception {
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, iterationCount);
        Cipher pbeCipher = Cipher.getInstance(cipher);
        pbeCipher.init(1, DecryptedStorage.getKey(cipher, pwd, salt, iterationCount), pbeParamSpec);
        byte[] data = this.asByteArray();
        byte[] encodedData = pbeCipher.doFinal(data);
        AlgorithmParameters param = pbeCipher.getParameters();
        return DecryptedStorage.toBase64(encodedData) + SEP + DecryptedStorage.calculateSignature(data, pwd) + SEP + DecryptedStorage.toBase64(param.getEncoded()) + SEP + param.getAlgorithm();
    }

    private byte[] asByteArray() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeLong(this.nextId);
        oos.writeObject(this.storeId);
        oos.writeObject(this.objects);
        oos.flush();
        return bos.toByteArray();
    }

    private static String calculateSignature(byte[] data, String pwd) throws Exception {
        SecretKeySpec signingKey = new SecretKeySpec(pwd.getBytes(), HMAC_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_ALGORITHM);
        mac.init(signingKey);
        return DecryptedStorage.toBase64(mac.doFinal(data));
    }

    private static String toBase64(byte[] data) throws UnsupportedEncodingException {
        return Base64.getEncoder().encodeToString(data);
    }

    private static byte[] fromBase64(String data) throws UnsupportedEncodingException {
        return Base64.getDecoder().decode(data);
    }

    private static Key getKey(String cipher, String pwd, byte[] salt, int iterationCount) throws Exception {
        PBEKeySpec keySpec = new PBEKeySpec(pwd.toCharArray(), salt, iterationCount);
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(cipher);
        return keyFac.generateSecret(keySpec);
    }
}

