/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.common.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.Assert;
import org.openjdk.jmc.common.io.ValidatingObjectInputStream;
import org.openjdk.jmc.common.security.FailedToSaveException;
import org.openjdk.jmc.common.security.SecurityException;
import org.openjdk.jmc.ui.common.CorePlugin;
import org.openjdk.jmc.ui.common.security.DecryptedStorage;
import org.osgi.service.prefs.Preferences;

public class SecureStore {
    public static final Set<String> ENCRYPTION_CIPHERS;
    public static final String DEFAULT_CIPHER;
    private static final String XML_ELEMENT_SECURE_STORE = "secureStore";
    private static final String XML_ELEMENT_KEYS = "secureStoreKeys";
    private static final String XML_ELEMENT_CIPHER = "secureStoreCipher";
    private static final String[] PREFERRED_CIPHERS;
    private static final String[] WEAK_CIPHERS;
    private static final Set<String> weakCiphers;
    private static final String SEP = "_";
    private DecryptedStorage storage;
    private String pwd;
    private String cipher;
    private Preferences prefs;
    private Set<String> keys;

    static {
        PREFERRED_CIPHERS = new String[]{"PBEWithHmacSHA512AndAES_256", "PBEWithHmacSHA512AndAES_128"};
        WEAK_CIPHERS = new String[]{"PBEWithMD5AndDES", "PBEWithMD5AndTripleDES", "PBEWithSHA1AndRC2_40", "PBEWithSHA1AndRC4_40"};
        weakCiphers = new HashSet<String>();
        weakCiphers.addAll(Arrays.asList(WEAK_CIPHERS));
        HashSet<String> ciphers = new HashSet<String>();
        String pwdForTest = "pwd";
        byte[] saltForTest = new byte[8];
        int iterationCountForTest = 4711;
        Provider[] providerArray = Security.getProviders();
        int n = providerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Provider provider = providerArray[n2];
            for (Provider.Service service : provider.getServices()) {
                String algorithm = service.getAlgorithm();
                if (!"cipher".equalsIgnoreCase(service.getType()) || weakCiphers.contains(algorithm)) continue;
                try {
                    DecryptedStorage testStore = new DecryptedStorage();
                    String encrypted = testStore.getEncrypted(algorithm, pwdForTest, saltForTest, iterationCountForTest);
                    new DecryptedStorage(encrypted, algorithm, pwdForTest);
                    ciphers.add(algorithm);
                }
                catch (Exception e) {
                    CorePlugin.getDefault().getLogger().log(Level.FINER, "Cipher " + algorithm + " doesn't support PBE: " + String.valueOf(e));
                }
            }
            ++n2;
        }
        ENCRYPTION_CIPHERS = Collections.unmodifiableSet(ciphers);
        DEFAULT_CIPHER = SecureStore.findDefaultCipher();
    }

    private static String findDefaultCipher() {
        String[] stringArray = PREFERRED_CIPHERS;
        int n = PREFERRED_CIPHERS.length;
        int n2 = 0;
        while (n2 < n) {
            String pc = stringArray[n2];
            if (ENCRYPTION_CIPHERS.contains(pc)) {
                return pc;
            }
            ++n2;
        }
        String lastCipher = null;
        Iterator<String> iterator = ENCRYPTION_CIPHERS.iterator();
        while (iterator.hasNext()) {
            String c;
            lastCipher = c = iterator.next();
        }
        return lastCipher;
    }

    public SecureStore(Preferences prefs) {
        byte[] keysData = prefs.getByteArray(XML_ELEMENT_KEYS, null);
        if (keysData == null) {
            this.keys = new HashSet<String>();
        } else {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ValidatingObjectInputStream ois = ValidatingObjectInputStream.build((InputStream)new ByteArrayInputStream(keysData));){
                    HashSet k;
                    this.keys = k = (HashSet)ois.safeReadObject(HashSet.class, Arrays.asList(String.class), 100000, 1000000L);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                CorePlugin.getDefault().getLogger().log(Level.WARNING, "Could not load SecureStore keys", e);
                this.keys = new HashSet<String>();
            }
        }
        if (!ENCRYPTION_CIPHERS.isEmpty()) {
            this.prefs = prefs;
            this.cipher = prefs.get(XML_ELEMENT_CIPHER, DEFAULT_CIPHER);
        } else {
            this.doInitialize(new DecryptedStorage());
        }
    }

    public static SecureStore createDefault() {
        return new SecureStore(CorePlugin.getDefault().getPreferences().node(SecureStore.class.getName()));
    }

    private synchronized String insertInternal(String key, boolean keyFamily, Object value) throws FailedToSaveException {
        Assert.isTrue((boolean)this.isInitialized());
        key = keyFamily || key == null ? this.generateKey(key) : key;
        this.storage.objects.put(key, value);
        this.keys.add(key);
        this.save();
        return key;
    }

    public String insert(String key, boolean keyFamily, String value) throws FailedToSaveException {
        return this.insertInternal(key, keyFamily, value);
    }

    public String insert(String key, boolean keyFamily, String[] value) throws FailedToSaveException {
        return this.insertInternal(key, keyFamily, value);
    }

    public String insert(String key, boolean keyFamily, byte[] value) throws FailedToSaveException {
        return this.insertInternal(key, keyFamily, value);
    }

    private String generateKey(String family) {
        return this.storage.nextId++ + SEP + this.storage.storeId.toString() + (String)(family == null ? "" : SEP + family);
    }

    public synchronized Object get(String key) {
        Assert.isTrue((boolean)this.isInitialized());
        return this.storage.objects.get(key);
    }

    public synchronized void clearFamily(String family, Set<String> keepKeys) throws FailedToSaveException {
        Iterator<String> it = this.keys.iterator();
        while (it.hasNext()) {
            String key = it.next();
            String[] keyParts = key.split(SEP);
            if (keyParts.length != 3 || !keyParts[2].equals(family) || keepKeys.contains(key)) continue;
            it.remove();
        }
        if (this.isInitialized()) {
            this.cleanupStorage();
        }
        this.save();
    }

    public synchronized boolean hasKey(String key) {
        return this.keys.contains(key);
    }

    private void cleanupStorage() {
        HashSet<String> removeKeys = new HashSet<String>(this.storage.objects.keySet());
        removeKeys.removeAll(this.keys);
        for (String key : removeKeys) {
            this.storage.objects.remove(key);
        }
    }

    public synchronized Object remove(String key) throws FailedToSaveException {
        Object o = null;
        this.keys.remove(key);
        if (this.isInitialized()) {
            o = this.storage.objects.remove(key);
        }
        this.save();
        return o;
    }

    public synchronized String getEncryptionCipher() {
        return this.cipher;
    }

    public synchronized void setEncryptionCipher(String cipher) throws SecurityException {
        Assert.isTrue((boolean)this.isInitialized());
        if (cipher == null || !ENCRYPTION_CIPHERS.contains(cipher)) {
            throw new SecurityException("Cipher " + cipher + " is not available");
        }
        this.cipher = cipher;
        this.save();
    }

    public synchronized boolean isInitialized() {
        return this.storage != null;
    }

    public synchronized boolean isEncrypted() {
        return !this.isInitialized() && this.prefs.get(XML_ELEMENT_SECURE_STORE, null) != null;
    }

    public synchronized boolean isPersistable() {
        return this.prefs != null;
    }

    public synchronized void initialize() {
        if (!this.isInitialized()) {
            this.doInitialize(new DecryptedStorage());
            this.cipher = DEFAULT_CIPHER;
            this.keys = new HashSet<String>();
        }
    }

    public synchronized void initialize(String pwd) throws Exception {
        Assert.isTrue((boolean)this.isEncrypted());
        this.doInitialize(new DecryptedStorage(this.prefs.get(XML_ELEMENT_SECURE_STORE, null), this.cipher, pwd));
        this.pwd = pwd;
        this.cleanupStorage();
        this.save();
    }

    public synchronized void setPassword(String pwd) throws FailedToSaveException {
        Assert.isTrue((boolean)this.isInitialized());
        this.pwd = pwd;
        this.save();
    }

    private synchronized void doInitialize(DecryptedStorage storage) {
        this.storage = storage;
    }

    private void save() throws FailedToSaveException {
        try {
            if (this.isPersistable()) {
                if (this.isInitialized()) {
                    String encrypted = this.storage.getEncrypted(this.cipher, this.pwd);
                    this.prefs.put(XML_ELEMENT_CIPHER, this.cipher);
                    this.prefs.put(XML_ELEMENT_SECURE_STORE, encrypted);
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(this.keys);
                oos.flush();
                this.prefs.putByteArray(XML_ELEMENT_KEYS, bos.toByteArray());
                this.prefs.flush();
            }
        }
        catch (Exception e) {
            this.prefs = null;
            CorePlugin.getDefault().getLogger().log(Level.SEVERE, "Could not save secure store", e);
            throw new FailedToSaveException((Throwable)e);
        }
    }
}

