/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.ui.celleditors;

import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Composite;
import org.openjdk.jmc.ui.celleditors.CommonCellEditors;
import org.openjdk.jmc.ui.celleditors.Messages;

public class ClearableTextCellEditor
extends CommonCellEditors.MultiLineTextCellEditor {
    public ClearableTextCellEditor(Composite parent) {
        super(parent);
    }

    public boolean allowClear() {
        return true;
    }

    @Override
    public String getInfoText() {
        String thisInfo = this.allowClear() ? Messages.ClearableTextCellEditor_PRESS_BACKSPACE_TO_CLEAR_VALUE : null;
        String superInfo = super.getInfoText();
        return thisInfo != null ? superInfo + System.lineSeparator() + thisInfo : superInfo;
    }

    protected void clear() {
    }

    @Override
    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\b' && this.text.getText().length() == 0 && this.allowClear()) {
            this.clear();
            this.fireApplyEditorValue();
            this.deactivate();
        } else {
            super.keyReleaseOccured(keyEvent);
        }
    }
}

