/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.greychart.providers;

import org.openjdk.jmc.greychart.impl.SamplePoint;
import org.openjdk.jmc.greychart.providers.AbstractSampler;

public final class StackingBuffer
extends AbstractSampler {
    private int prevIndex = Integer.MAX_VALUE;
    private double previousY;

    public StackingBuffer(int size) {
        super(size);
    }

    public void startSeries() {
        this.prevIndex = Integer.MAX_VALUE;
    }

    public void addNonNormalizedDataPoint(int index, double currentY) {
        SamplePoint sp = this.getSamplePoint(index);
        ++sp.count;
        sp.y += currentY;
        int x = this.prevIndex;
        while (x < index) {
            SamplePoint samplePoint = this.getSamplePoint(x);
            samplePoint.y += this.previousY + (currentY - this.previousY) / (double)(index - this.prevIndex) * (double)(x - this.prevIndex);
            ++x;
        }
        this.prevIndex = index + 1;
        this.previousY = currentY;
        this.invalidateStatistics();
    }
}

