/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.util.logging;

import com.azul.crs.client.Tweaks;
import com.azul.crs.util.logging.Config;
import com.azul.crs.util.logging.LogConfiguration;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class Logger {
    private static final Map<String, Logger> TAG_TO_LOGGER = new HashMap<String, Logger>();
    private static final String NO_TAG_LOGGER_IDENTIFICATION = "default";
    private static final List<PrintWriter> writers = new CopyOnWriteArrayList<PrintWriter>();
    private static final long vmStartTime = System.currentTimeMillis() - ManagementFactory.getRuntimeMXBean().getUptime();
    private static final AtomicBoolean notInitialized = new AtomicBoolean(true);
    private static LogConfiguration logConfiguration;
    private final String tag;
    private final Config config;

    static void reset() {
        TAG_TO_LOGGER.clear();
        notInitialized.set(true);
    }

    private Logger(String string, Config config) {
        this.tag = string;
        this.config = config;
    }

    private static Logger loggerForTag(String string) {
        if (string == null) {
            Logger logger = TAG_TO_LOGGER.get(NO_TAG_LOGGER_IDENTIFICATION);
            if (logger == null) {
                Config config = logConfiguration.getConfig(null);
                logger = new Logger(NO_TAG_LOGGER_IDENTIFICATION, config);
                TAG_TO_LOGGER.put(NO_TAG_LOGGER_IDENTIFICATION, logger);
            }
            return logger;
        }
        Logger logger = TAG_TO_LOGGER.get(string);
        if (logger == null) {
            Config config = logConfiguration.getConfig(string);
            logger = new Logger(string, config);
            TAG_TO_LOGGER.put(string, logger);
        }
        return logger;
    }

    public static void addOutputStream(OutputStream outputStream) {
        writers.add(new PrintWriter(outputStream));
    }

    public static Logger getLogger(Class clazz) {
        if (notInitialized.get()) {
            Logger.init(Collections.EMPTY_LIST);
        }
        String string = clazz.getCanonicalName();
        String string2 = logConfiguration.getTagForClass(string);
        return Logger.loggerForTag(string2);
    }

    public static void parseOptions(Collection<Map.Entry<String, String>> collection) {
        Logger.init(collection);
    }

    private static synchronized void init(Collection<Map.Entry<String, String>> collection) {
        if (notInitialized.get()) {
            logConfiguration = new LogConfiguration(collection);
        } else {
            logConfiguration.reconfigure(collection);
        }
        notInitialized.set(false);
    }

    public void trace(String string, Object ... objectArray) {
        this.log(Level.TRACE, string, objectArray);
    }

    public void debug(String string, Object ... objectArray) {
        this.log(Level.DEBUG, string, objectArray);
    }

    public void info(String string, Object ... objectArray) {
        this.log(Level.INFO, string, objectArray);
    }

    public void warning(String string, Object ... objectArray) {
        this.log(Level.WARNING, string, objectArray);
    }

    public void error(String string, Object ... objectArray) {
        this.log(Level.ERROR, string, objectArray);
    }

    public void log(Level level, String string, Object ... objectArray) {
        try {
            Object object2;
            StringBuilder stringBuilder;
            boolean bl = this.isUpstreamLevelEnabled(level);
            boolean bl2 = this.isDownstreamLevelEnabled(level);
            if (!bl && !bl2) {
                return;
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            if (this.showTimestamp()) {
                stringBuilder2.append(this.elapsedTime());
            }
            stringBuilder2.append("[CRS.").append(this.tag).append("][").append(level.n).append("] ");
            if (bl2) {
                stringBuilder = new StringBuilder(stringBuilder2);
                if (this.config.getDownstreamLevel() == Level.TRACE) {
                    object2 = new Throwable();
                    StackTraceElement object3 = ((Throwable)object2).getStackTrace()[2];
                    stringBuilder2.append(object3.getClassName()).append('.').append(object3.getMethodName()).append(": ");
                }
                this.logDecoratedLines(level, this.config.showDownstreamStacktrace(), new PrintWriter(System.err), stringBuilder, string, objectArray);
            }
            if (bl) {
                if (!this.showTimestamp()) {
                    stringBuilder2.insert(0, this.elapsedTime());
                }
                stringBuilder = new StringBuilder(stringBuilder2);
                if (this.config.getUpstreamLevel() == Level.TRACE) {
                    object2 = new Throwable();
                    StackTraceElement stackTraceElement = ((Throwable)object2).getStackTrace()[2];
                    stringBuilder2.append(stackTraceElement.getClassName()).append('.').append(stackTraceElement.getMethodName()).append(": ");
                }
                for (PrintWriter printWriter : writers) {
                    this.logDecoratedLines(level, this.config.showUpstreamStacktrace(), printWriter, stringBuilder, string, objectArray);
                }
            }
        }
        catch (Throwable throwable) {
            java.util.logging.Logger.getLogger(Logger.class.getName()).log(java.util.logging.Level.SEVERE, null, throwable);
        }
    }

    boolean showTimestamp() {
        return logConfiguration.showTimestamp();
    }

    boolean isDownstreamLevelEnabled(Level level) {
        return this.config.getDownstreamLevel().ordinal() <= level.ordinal();
    }

    boolean isUpstreamLevelEnabled(Level level) {
        return this.config.getUpstreamLevel().ordinal() <= level.ordinal();
    }

    Config getConfig() {
        return this.config;
    }

    public boolean isEnabled(Level level) {
        return this.config.getUpstreamLevel().ordinal() <= level.ordinal() || this.config.getDownstreamLevel().ordinal() <= level.ordinal();
    }

    private CharSequence elapsedTime() {
        long l = System.currentTimeMillis() - vmStartTime;
        long l2 = l / 1000L;
        long l3 = l % 1000L;
        CharSequence charSequence = Long.toString(1000L + l3).subSequence(1, 4);
        return l2 + "." + charSequence + ": ";
    }

    private String newLineIndentation(StringBuilder stringBuilder, int n, String string) {
        stringBuilder.append("\n");
        stringBuilder.append(string);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("    ");
        }
        return stringBuilder.toString();
    }

    private String prettyPrint(String string) {
        return this.prettyPrint(string, "");
    }

    private String prettyPrint(String string, String string2) {
        if (!Tweaks.UGLY_PRETTY_PRINT_FOR_DEBUG || string == null || string.length() < 80) {
            return string;
        }
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (i < cArray.length - 4 && cArray[i] == '\t' && cArray[i + 1] == 'a' && cArray[i + 2] == 't' && cArray[i + 3] == ' ') {
                bl = true;
            }
            if (!bl) {
                if (c == '(' || c == '[' || c == '{') {
                    int n2;
                    for (n2 = i + 1; n2 < cArray.length - 1 && "([{)]},".indexOf(cArray[n2]) == -1; ++n2) {
                    }
                    if (n2 < cArray.length - 1 && "([{".indexOf(c) == ")]}".indexOf(cArray[n2])) {
                        while (i <= n2) {
                            stringBuilder.append(cArray[i]);
                            ++i;
                        }
                        i = n2;
                        continue;
                    }
                    this.newLineIndentation(stringBuilder, n, string2);
                    stringBuilder.append(c);
                    this.newLineIndentation(stringBuilder, ++n, string2);
                    continue;
                }
                if (c == ')' || c == ']' || c == '}') {
                    this.newLineIndentation(stringBuilder, --n, string2);
                    stringBuilder.append(c);
                    this.newLineIndentation(stringBuilder, n, string2);
                    continue;
                }
                if (c == ',') {
                    stringBuilder.append(c);
                    this.newLineIndentation(stringBuilder, n, string2);
                    continue;
                }
            }
            if (i != cArray.length - 1 && c == '\n') {
                this.newLineIndentation(stringBuilder, n, string2);
                bl = false;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void logDecoratedLines(Level level, boolean bl, PrintWriter printWriter, StringBuilder stringBuilder, String string2, Object ... objectArray) {
        boolean bl2;
        printWriter.append(stringBuilder);
        for (char n : this.prettyPrint(String.format(string2, objectArray)).toCharArray()) {
            printWriter.append(n);
            if (n != '\n') continue;
            printWriter.append(stringBuilder);
        }
        printWriter.println();
        boolean bl3 = bl2 = level == Level.ERROR && Tweaks.FORCE_PRINT_STACKTRACE_IN_ERROR;
        if (bl || bl2) {
            void var10_14;
            Object[] objectArray2 = objectArray;
            int n = objectArray2.length;
            boolean bl4 = false;
            while (var10_14 < n) {
                Object object = objectArray2[var10_14];
                if (object instanceof Throwable) {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter2 = new PrintWriter(stringWriter);
                    ((Throwable)object).printStackTrace(printWriter2);
                    String string3 = Arrays.stream(this.prettyPrint(stringWriter.toString(), " >> ").split("\n")).map(string -> "" + stringBuilder.toString() + string).collect(Collectors.joining("\n"));
                    printWriter.append(string3);
                }
                ++var10_14;
            }
        }
        printWriter.flush();
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        OFF;

        private final String n = this.name().toLowerCase();
    }
}

